﻿Public Class Form1

    Dim Cost As Double = 0
    Dim Power As Double = 0
    Dim Usage As Double = 0
    Dim Appliance As String = ""
    Dim TotalOperatingCost As Double = 0
    Dim Gallons As Double = 0
    Dim CostPerGallon As Double = 0


    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        cmbAppliance.SelectedIndex = 0
    End Sub

    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        'form validation
        If Not IsNumeric(txtCost.Text) Then
            txtCost.Clear()
            txtCost.Focus()
            MessageBox.Show("Please enter a valid Cost", "Alert!")
            Return
        Else
            Cost = Convert.ToDouble(txtCost.Text)
        End If

        If cmbAppliance.SelectedIndex = 0 Then
            cmbAppliance.Focus()
            MessageBox.Show("Please select an Appliance", "Alert!")
            Return
        Else
            Appliance = cmbAppliance.SelectedItem.ToString()
        End If

        If Not IsNumeric(txtPower.Text) Then
            txtPower.Clear()
            txtPower.Focus()
            MessageBox.Show("Please enter the valid Power", "Alert!")
            Return
        Else
            Power = Convert.ToDouble(txtPower.Text)
        End If

        If Not IsNumeric(txtUsage.Text) Then
            txtUsage.Clear()
            txtUsage.Focus()
            MessageBox.Show("Please enter the valid Usage", "Alert!")
            Return
        Else
            Usage = Convert.ToDouble(txtUsage.Text)
            If Usage > 24 Then
                txtUsage.Clear()
                txtUsage.Focus()
                MessageBox.Show("Please enter valid number of Hours", "Alert!")
                Return
            End If
        End If

        'Validate washer fields
        If txtGallons.Visible = True Then
            If Not IsNumeric(txtGallons.Text) Then
                txtGallons.Clear()
                txtGallons.Focus()
                MessageBox.Show("Please enter the valid Number of Gallons", "Alert!")
                Return
            Else
                Gallons = Convert.ToDouble(txtGallons.Text)
            End If
        End If

        If txtCostPerGallons.Visible = True Then
            If Not IsNumeric(txtCostPerGallons.Text) Then
                txtCostPerGallons.Clear()
                txtCostPerGallons.Focus()
                MessageBox.Show("Please enter the valid cost per Gallons", "Alert!")
                Return
            Else
                CostPerGallon = Convert.ToDouble(txtCostPerGallons.Text)
            End If
        End If

        ' calculating the cost
        TotalOperatingCost = Power * Usage * Cost

        ' check if washer appliance and add the gallons cost
        If cmbAppliance.Text = "Laundry Washer" Or cmbAppliance.Text = "Cloth Washer" Then
            TotalOperatingCost = TotalOperatingCost + (Gallons * CostPerGallon)
        End If

        ' display the listing
        lblHomeAppl.Text = "Home Appliance: " + Appliance.ToString()
        lblHours.Text = "Number of hours per day: " + Usage.ToString()
        lblCost.Text = "Cost: " + TotalOperatingCost.ToString()
    End Sub

    Private Sub btnReset_Click(sender As Object, e As EventArgs) Handles btnReset.Click
        txtCost.Clear()
        cmbAppliance.SelectedIndex = 0
        txtPower.Clear()
        txtUsage.Clear()
        lblCost.Text = ""
        lblHomeAppl.Text = ""
        lblHours.Text = ""
    End Sub

    Private Sub btnClose_Click(sender As Object, e As EventArgs) Handles btnClose.Click
        Me.Close()
    End Sub

    Private Sub cmbAppliance_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cmbAppliance.SelectedIndexChanged
        If cmbAppliance.Text = "Laundry Washer" Or cmbAppliance.Text = "Cloth Washer" Then
            lblGallons.Visible = True
            txtGallons.Visible = True
            lblCostPerGallon.Visible = True
            txtCostPerGallons.Visible = True
        Else
            lblGallons.Visible = False
            txtGallons.Visible = False
            lblCostPerGallon.Visible = False
            txtCostPerGallons.Visible = False
        End If
    End Sub
End Class
